/*!
 * SimpleSlider v1.9.0
 * Simple responsive slider created in pure javascript.
 * https://github.com/michu2k/SimpleSlider
 *
 * Copyright 2017-2019 Michał Strumpf
 * Published under MIT License
 */
"use strict";function _typeof(e){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function _toConsumableArray(e){return _arrayWithoutHoles(e)||_iterableToArray(e)||_nonIterableSpread()}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance")}function _iterableToArray(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}function _arrayWithoutHoles(e){if(Array.isArray(e)){for(var t=0,n=new Array(e.length);t<e.length;t++)n[t]=e[t];return n}}!function(i){function e(s,e){var d=this,t=1<arguments.length&&void 0!==e?e:{};this.init=function(){d.options=n({speed:600,delay:5e3,enableDrag:!0,autoplay:!1,loop:!0,slidesPerView:{},class:{wrapper:"slider-wrapper",slide:"slider-slide",buttons:"slider-btn",pagination:"slider-pagination",paginationItem:"pagination-bullet"},onInit:function(){},onChange:function(){}},t),function(){var e=d.options,t=e.slidesPerView,n=e.class,i=n.wrapper,a=n.slide,r=n.buttons,o=n.pagination;d.container=document.querySelector(s),d.wrapper=d.container.querySelector(".".concat(i)),d.slides=d.container.querySelectorAll(".".concat(a)),d.buttons=d.container.querySelectorAll(".".concat(r)),d.pagination=d.container.querySelector(".".concat(o)),d.disableEvents=!1,d.slidesWithClones=d.slides,d.maxSlidesPerView=Math.max.apply(Math,_toConsumableArray(Object.keys(t).map(function(e){return t[e]})).concat([1])),d.index=0,d.wrapperWidth=0,d.transitionDuration=l("transitionDuration"),d.transform=l("transform"),d.timer,d.drag={startX:0,endX:0,dragDiff:0,focused:!1,isLink:!1}}();var e=d.options.onInit;d.calculateSlidesPerView(),d.createClones(),d.setWidth(),d.moveWrapper(),d.createPagination(),d.autoplay(),d.attachEvents(),e()},this.attachEvents=function(){var e=d.options.enableDrag,t=d.container;["touchstartHandler","touchmoveHandler","touchendHandler","clickHandler","mousedownHandler","mousemoveHandler","mouseupHandler","mouseleaveHandler","resizeHandler","visibilitychangeHandler","paginationBulletsHandler","prevSlide","nextSlide"].map(function(e){d[e]=d[e].bind(d)}),e&&(t.addEventListener("touchstart",d.touchstartHandler),t.addEventListener("touchmove",d.touchmoveHandler),t.addEventListener("touchend",d.touchendHandler),t.addEventListener("click",d.clickHandler),t.addEventListener("mousedown",d.mousedownHandler),t.addEventListener("mousemove",d.mousemoveHandler),t.addEventListener("mouseup",d.mouseupHandler),t.addEventListener("mouseleave",d.mouseleaveHandler)),t.addEventListener("click",d.paginationBulletsHandler),2===d.buttons.length&&(d.buttons[0].addEventListener("click",d.prevSlide),d.buttons[1].addEventListener("click",d.nextSlide)),i.addEventListener("resize",d.resizeHandler),i.addEventListener("visibilitychange",d.visibilitychangeHandler)},this.detachEvents=function(){var e=d.container;e.removeEventListener("touchstart",d.touchstartHandler),e.removeEventListener("touchmove",d.touchmoveHandler),e.removeEventListener("touchend",d.touchendHandler),e.removeEventListener("click",d.clickHandler),e.removeEventListener("mousedown",d.mousedownHandler),e.removeEventListener("mousemove",d.mousemoveHandler),e.removeEventListener("mouseup",d.mouseupHandler),e.removeEventListener("mouseleave",d.mouseleaveHandler),e.removeEventListener("click",d.paginationBulletsHandler),d.buttons[0].removeEventListener("click",d.prevSlide),d.buttons[1].removeEventListener("click",d.nextSlide),i.removeEventListener("resize",d.resizeHandler),i.removeEventListener("visibilitychange",d.visibilitychangeHandler)},this.calculateSlidesPerView=function(){var e=d.options,t=e.loop,n=e.slidesPerView;d.slidesPerView=1,Object.keys(n).forEach(function(e){document.body.offsetWidth>=e&&(d.slidesPerView=n[e])}),d.maxIndex=t?d.slides.length:d.slides.length-d.slidesPerView+1},this.createClones=function(){if(d.options.loop){for(var e,t=d.options.class.slide,n=d.wrapper,i=d.slides.length-1,a=document.createDocumentFragment(),r=document.createDocumentFragment(),o=0;o<d.maxSlidesPerView&&!(i-o<0||i<o);o++)e=n.children[i-o].cloneNode(!0),r.insertBefore(e,r.childNodes[0]),e=n.children[o].cloneNode(!0),a.appendChild(e);n.appendChild(a),n.insertBefore(r,d.slides[0]),d.slidesWithClones=d.container.querySelectorAll(".".concat(t))}},this.setWidth=function(){var n=Math.round(d.container.offsetWidth/d.slidesPerView)+"px";d.wrapperWidth=0,Object.keys(d.slidesWithClones).map(function(e){var t=d.slidesWithClones[e];t.style.width=n,d.wrapperWidth+=t.offsetWidth}),d.wrapper.style.width=d.wrapperWidth+"px"},this.moveWrapper=function(){var e=d.options.loop,t=d.maxSlidesPerView+1-d.slidesPerView+Math.floor(d.slidesPerView/2)+d.index;d.wrapperPosition=0,e||(t=d.index>=d.maxIndex-Math.floor(d.slidesPerView/2)?d.maxIndex-1:d.index);for(var n=0;n<t;n++)d.wrapperPosition+=d.slidesWithClones[n].offsetWidth;d.wrapper.style[d.transform]="translate3d(-".concat(d.wrapperPosition,"px, 0, 0)")},this.changeSlide=function(){var e=0<arguments.length&&void 0!==arguments[0]&&arguments[0],t=d.options,n=t.speed,i=t.loop,a=t.onChange;d.disableEvents||(e||(d.resetAutoplay(),d.autoplay()),i?d.disableEvents=!0:(0<=d.index&&d.index<d.maxIndex&&(d.disableEvents=!0),d.index=d.updateIndex(d.index)),d.highlightPaginationBullet(),d.wrapper.style[d.transitionDuration]=n+"ms",d.moveWrapper(),a(),setTimeout(function(){i&&(d.index<0||d.index>=d.slides.length)&&(d.index=d.updateIndex(d.index),d.wrapper.style[d.transitionDuration]="0ms",d.moveWrapper()),d.disableEvents=!1},n))},this.createPagination=function(){if(d.pagination){for(var e,t=d.options,n=t.loop,i=t.class.paginationItem,a=document.createDocumentFragment(),r=n?0:Math.min(d.index,d.maxIndex-1),o=0;o<d.maxIndex;o++)(e=document.createElement("span")).classList.add(i),o==r&&e.classList.add("is-active"),a.appendChild(e);d.pagination.appendChild(a),d.paginationBullets=d.pagination.querySelectorAll(".".concat(i))}},this.destroyPagination=function(){d.pagination&&(d.pagination.innerHTML="")},this.paginationBulletsHandler=function(e){var t=d.options.class.paginationItem,n=[];if(e.target.classList.contains(t)){for(var i=0;i<d.paginationBullets.length;i++)n.push(d.paginationBullets[i]);var a=n.indexOf(e.target);d.disableEvents||(d.index=a-1,d.nextSlide())}},this.highlightPaginationBullet=function(){if(d.pagination){var e=d.options.class.paginationItem;d.pagination.querySelector(".is-active").classList.remove("is-active"),d.pagination.querySelectorAll(".".concat(e))[d.updateIndex(d.index)].classList.add("is-active")}},this.prevSlide=function(){d.decreaseIndex(),d.changeSlide()},this.nextSlide=function(){d.increaseIndex(),d.changeSlide()},this.increaseIndex=function(){d.disableEvents||d.index++},this.decreaseIndex=function(){d.disableEvents||d.index--},this.updateIndex=function(e){return d.options.loop?e>=d.slides.length?0:e<0?d.slides.length-1:e:e>=d.maxIndex?d.maxIndex-1:e<=0?0:e},this.autoplay=function(){var e=d.options,t=e.autoplay,n=e.delay,i=e.speed;t&&(d.timer=setTimeout(function(){d.increaseIndex(),d.changeSlide(!0),d.autoplay()},n+i))},this.resetAutoplay=function(){return clearTimeout(d.timer)},this.updateSliderAfterDrag=function(){var e=d.options.speed;d.drag.focused=!1,d.drag.dragDiff&&(d.autoplay(),100<Math.abs(d.drag.dragDiff)&&(d.drag.dragDiff<0?d.nextSlide():d.prevSlide()),d.wrapper.style[d.transitionDuration]=e+"ms",d.moveWrapper(),d.drag.dragDiff=0,d.drag.isLink=!1)},this.updateSliderDuringDrag=function(){d.resetAutoplay();var e=d.options.loop,t=d.slides[d.index].offsetWidth,n=d.wrapperPosition-d.drag.dragDiff,i=100+t;d.drag.dragDiff=d.drag.endX-d.drag.startX,e||(d.index<=0&&0<d.drag.dragDiff&&(i=100),d.index>=d.maxIndex-1&&d.drag.dragDiff<0&&(i=100)),d.drag.dragDiff<i&&d.drag.dragDiff>-1*i?d.wrapper.style[d.transform]="translate3d(".concat(-1*n,"px, 0, 0)"):d.updateSliderAfterDrag()},this.mousedownHandler=function(e){e.stopPropagation(),e.preventDefault(),d.wrapper.style[d.transitionDuration]="0ms",d.drag.focused=!0,d.drag.startX=e.pageX},this.mousemoveHandler=function(e){e.stopPropagation(),!d.disableEvents&&d.drag.focused&&("A"===e.target.nodeName&&(d.drag.isLink=!0),d.drag.endX=e.pageX,d.updateSliderDuringDrag())},this.mouseupHandler=function(e){e.stopPropagation(),d.updateSliderAfterDrag()},this.mouseleaveHandler=function(e){e.stopPropagation(),d.updateSliderAfterDrag()},this.clickHandler=function(e){d.drag.isLink&&e.preventDefault(),d.drag.isLink=!1},this.touchstartHandler=function(e){e.stopPropagation(),d.wrapper.style[d.transitionDuration]="0ms",d.drag.focused=!0,d.drag.startX=e.touches[0].pageX},this.touchmoveHandler=function(e){e.stopPropagation(),!d.disableEvents&&d.drag.focused&&(d.drag.endX=e.touches[0].pageX,d.updateSliderDuringDrag())},this.touchendHandler=function(e){e.stopPropagation(),d.updateSliderAfterDrag()},this.visibilitychangeHandler=function(){d.resetAutoplay(),document.hidden||d.autoplay()},this.resizeHandler=function(){var e=d.options.loop,t=d.slidesPerView;d.wrapper.style[d.transitionDuration]="0ms",d.calculateSlidesPerView(),d.setWidth(),d.moveWrapper(),e||t===d.slidesPerView||(d.destroyPagination(),d.createPagination())};var l=function(e){return"string"==typeof document.documentElement.style[e]?e:(e=e.charAt(0).toUpperCase()+e.slice(1),"webkit".concat(e))},n=function(e,t){var n,i;if(null!=t&&"undefined"!=t)for(n in t){var a=t[n];if("object"===_typeof(a))for(i in a)e[n][i]=a[i];else e[n]=a}return e};this.init()}"undefined"!=typeof module&&void 0!==module.exports?module.exports=e:i.SimpleSlider=e}(window);