<!DOCTYPE html>
<?php

//
// ptiblogphp
//
// This is a simple blogging system, requires only standard PHP. All content
// is stored in filesystem (no database).
//
// Copyright (C) 2021-2025 Mateusz Viste
// Published under the terms of the MIT license.
//

$PVER = '20251216';

// preinit a few global settings with default values
$ENTRIES_PER_PAGE = 5;
$ADMINPASS = '';
$ADMINLOGIN = '';
$TITLE = "MISSING TITLE";
$DATELOCALE = 'en_US.UTF-8';
$TIMESTAMPFORMAT = 'written %A, %B %e, %Y at %H:%M';
$MYTIMEZONE = '';
$RESIZEJPG_MAXWIDTH = '';
$RESIZEJPG_MAXHEIGHT = '';
// lang
$LANG_USERNAME = 'username';
$LANG_PASSWORD = 'password';
$LANG_CANCEL = 'cancel';
$LANG_SIGNIN = 'sign in';
$LANG_SAVE = 'save';
$LANG_AUTHERR = 'invalid authentication';
$LANG_NEWENTRY = 'add a new entry';
$LANG_TITLE = 'title';
$LANG_MESSAGE = 'message';
$LANG_FILESMGMT = 'Files management';
$LANG_DROPFILESHERE = 'drop your files here';
$LANG_REFRESH = 'refresh';
$LANG_GOBACK = 'go back';
$LANG_SEARCH = 'search';
$LANG_NOMATCH = 'no articles matching';
$LANG_NOARTS = 'no articles';

include 'settings.php';
include 'Parsedown.php';

if (! empty($LANG)) {
  echo '<html lang="' . $LANG . '">' . "\n";
} else {
  echo '<html>' . "\n";
}
?>
  <head>
    <title><?php echo htmlentities($TITLE); ?></title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="generator" content="ptiblogphp/<?php echo $PVER; ?>">
    <link rel="stylesheet" type="text/css" href="style.css">
    <link rel="stylesheet" type="text/css" href="slide.css">
    <link rel="stylesheet" type="text/css" href="dropzone593/dropzone.min.css">
    <link rel="stylesheet" type="text/css" href="custom.css">
    <link rel="icon" type="image/png" href="icon.png">
  </head>

  <body>
    <div class="banner">
      <h1><?php echo htmlentities($TITLE); ?></h1>
    </div>

    <?php
      $isadmin = false;

      // funkcja ładująca listę artykułów
      function LadujArtykuly($filter = '') {
        $r = array();
        $dirhandle = opendir('data');
        if (! $dirhandle) return($r);
        while (($entry = readdir($dirhandle)) !== false) {
          if ($entry[0] == '.') continue; // ignoruj ukryte pliki i katalogi oraz '.' i '..'
          if (is_dir('data/' . $entry)) continue;   // ignoruj katalogi
          /* apply filtering, if any requested */
          if (!empty($filter)) {
            $art = file_get_contents('data/' . $entry);
            if (stristr($art, $filter) === false) continue;
          }
          $r[] = pathinfo($entry, PATHINFO_FILENAME);
        }
        closedir($dirhandle);
        arsort($r); // sortuj anty-alfanumerycznie
        return($r);
      }

      // ładuj listę plików z katalogu. Flaga:
      //   0 = wszystkie pliki
      //   1 = tylko zdjęcia
      //   2 = tylko nie-zdjęcia
      function ListaPlikow($artid, $flaga) {
        $r = array();
        $katalog = 'data/' . $artid;
        $dirhandle = opendir($katalog);
        if (! $dirhandle) return($r);
        while (($entry = readdir($dirhandle)) !== false) {
          if ($entry[0] == '.') continue; // ignoruj ukryte pliki i katalogi oraz '.' i '..'
          if (is_dir($katalog . '/' . $entry)) continue;   // ignoruj katalogi
          if (preg_match('/\.(jpg|jpeg|png)$/i', $entry)) {
            if ($flaga != 2) $r[$entry] = true;
          } else { // not a photo
            if ($flaga != 1) $r[$entry] = false;
          }
        }
        closedir($dirhandle);
        ksort($r); // sortuj alfanumerycznie
        return($r);
      }

      function LadujPlikLinii($plik) {
        $r = explode("\n", file_get_contents($plik), 2);
        return($r);
      }

      function PaginationLink($p, $search, $lastp = 0) {
        $args = array();
        if (($p != $lastp) && ($p != 0)) $args[] = 'p=' . $p;
        if (!empty($search)) $args[] = 'search=' . $search;

        $link = '';
        foreach ($args as $arg) {
          if (empty($link)) {
            $link .= '?' . $arg;
          } else {
            $link .= '&' . $arg;
          }
        }

        return('./' . $link);
      }

      // zwraca tablicę z listą stron dla paska paginacji
      // wartość 0 oznacza symbol '...'
      function ListaStronDoPaginacji($p, $maxp) {
        $r = array();
        if ($p == 0) $p = $maxp; // p=0 znaczy "ostatnia strona"
        $pierwsza = $p - 3;
        $ostatnia = $p + 3;
        while ($pierwsza < 1) {
          $pierwsza++;
          $ostatnia++;
        }
        while ($ostatnia > $maxp) {
          $ostatnia--;
          if ($pierwsza > 1) $pierwsza--;
        }
        // dodaj pierwszą stronę oraz symbol '...' jeśli potrzeba
        if ($pierwsza > 1) {
          $r[] = 1;
          $r[] = 0;
        } else {
          $r[] = $pierwsza;
        }
        // dodaj wszystkie 'środkowe' wartości
        for ($pp = $pierwsza + 1; $pp < $ostatnia; $pp++) $r[] = $pp;
        // dodaj ostatnią wartość, ew. poprzedzoną symbolem '...'
        if ($ostatnia < $maxp) {
          $r[] = 0;
          $r[] = $maxp;
        } else if ($ostatnia != $pierwsza) {
          $r[] = $ostatnia;
        }

        // jeśli tylko jedna strona to daj se spokój
        if (count($r) < 2) $r = array();

        return(array_reverse($r));
      }

      function markdownoutput($md) {
        $Parsedown = new Parsedown();
        $Parsedown->setBreaksEnabled(true);
        echo $Parsedown->text($md) . "\n";
      }

      // ustaw locale dla generowania dat
      setlocale(LC_TIME, $DATELOCALE);

      // strefa czasowa dla obliczania lokalnych dat i godzin
      if (!empty($MYTIMEZONE)) date_default_timezone_set($MYTIMEZONE);

      // czytaj zmienne przekazane via get
      $p = 0;
      $action = "";
      $artid = "";
      if (!empty($_GET['p'])) $p = intval($_GET['p']);
      if (!empty($_GET['action'])) $action = $_GET['action'];
      if (!empty($_GET['artid'])) $artid = $_GET['artid'];
      if (!empty($_GET['zdjid'])) $zdjid = $_GET['zdjid'];
      if (!empty($_GET['search'])) $filter = $_GET['search'];

      // nadpisz zmienne jeśli dostalismy operację POST
      if (!empty($_POST['p'])) $p = intval($_POST['p']);
      if (!empty($_POST['action'])) $action = $_POST['action'];
      if (!empty($_POST['artid'])) $artid = $_POST['artid'];

      // inicjalizacja sesji
      session_set_cookie_params(3600 * 24 * 365); // set auth cookie lifetime to 1 year
      session_start();

      // czy dostałem hasło? jeśli tak, sprawdź czy cokolwiek warte
      if ((isset($_POST['password'])) && (isset($_POST['login']))) {
        if ((!empty($ADMINPASS)) && ($_POST['login'] === $ADMINLOGIN) && ($_POST['password'] === $ADMINPASS)) {
          $_SESSION['login'] = $_POST['login'];
        } else {
          echo '<p class="autherr">' . htmlentities($LANG_AUTHERR) . '</p>' . "\n";
        }
      }

      // prośba o logout?
      if ($action === 'logout') {
        session_destroy();
        unset($_SESSION);
        $action = '';
      }

      // admin?
      if ($_SESSION['login'] === $ADMINLOGIN) $isadmin = true;

      if (isset($_SESSION['login'])) {
        echo "<p class=\"bonjour\">{$_SESSION['login']} <a href=\"./?action=logout&amp;p={$p}\"><img src=\"svg/padlockopen.svg\"></a></p>\n";
      } else {
        echo "<p class=\"bonjour\"><a href=\"./?action=login&amp;p={$p}\"><img src=\"svg/padlockclosed.svg\"></a></p>\n";
      }

      echo '<div class="zawartosc">' . "\n";

      // wyświetl błąd jeśli nie-admin coś kombinuje
      if (! $isadmin) {
        if (($action === 'nowywpis') || ($action === 'dodajwpis')) {
          echo '<p class="autherr">' . htmlentities($LANG_AUTHERR) . '</p>' . "\n";
          $action = '';
        }
      }

      // dodanie nowego wpisu? (albo edycja istniejącego)
      if (($isadmin) && ($action === 'dodajwpis')) {
        if (empty($artid) || $artid == 0) $artid = time(); // notka: date_default_timezone_set() nie ma wpływu na time(), ten zawsze zwraca timestamp UTC (unix epoch)
        if ($artid < 0) {
          $dh = fopen('welcome.txt', 'w');
          fwrite($dh, trim($_POST['artbody']));
          fclose($dh);
        } else {
          $artfile = 'data/' . $artid . '.txt';
          if (!is_dir('data')) {
            if (!mkdir('data')) echo "<!-- mkdir(data) error! -->\n"; // stwórz katalog danych jeśli jeszcze nie istnieje
          }
          $dh = fopen($artfile, 'w');
          fwrite($dh, trim($_POST['arttit']));
          fwrite($dh, "\n");
          fwrite($dh, trim($_POST['artbody']));
          fclose($dh);
          // empty art? (delete)
          if (empty(trim($_POST['arttit'])) && empty(trim($_POST['artbody'])) && empty(ListaPlikow($artid, 0))) {
            unlink("data/{$artid}.txt");
            if (is_dir("data/{$artid}")) rmdir("data/{$artid}");
          }
        }
        $action = '';
      }

      if (($p == 0) && (empty($action))) {
        if ($isadmin) {
          echo "<p class=\"admintool\"><a href=\"./?action=nowywpis&amp;artid=-1&amp;p={$p}\"><img src=\"svg/edit.svg\"></a></p>\n";
        }
        markdownoutput(file_get_contents('welcome.txt'));
      } else if (($action === 'nowywpis') && (empty($artid))) {
        echo '<p>' . htmlentities($LANG_NEWENTRY) . "</p>\n";
      } else if ($action === 'login') {
        echo '<div class="authbox">' . "\n";
        echo '<div class="authimg"><img src="svg/padlockclosed.svg"></div>' . "\n";
        echo '<div class="auth">' . "\n";
        echo '<form action="' . PaginationLink($p, '') . '" method="post" class="auth">' . "\n";
        echo '<div class="authcred">' . "\n";
        echo '<input type="text" name="login" id="login" placeholder="' . htmlentities($LANG_USERNAME) . '"><br>' . "\n";
        echo '<input type="password" name="password" id="password" placeholder="' . htmlentities($LANG_PASSWORD) . '"><br>' . "\n";
        echo "</div>\n";
        echo '<div class="buttons"><div><a href="' . PaginationLink($p, '') . '">' . htmlentities($LANG_CANCEL) . '</a></div><div><input type="submit" value="' . htmlentities($LANG_SIGNIN) . '"></div></div>' . "\n";
        echo "</form>\n";
        echo "</div>\n";
        echo "</div>\n";
        goto BOTTOM;
      }

      // załaduj skrypt simpleSlider carousel: https://github.com/michu2k/SimpleSlider
      echo '<script src="SimpleSlider-v.1.9.0/dist/simpleSlider.min.js"></script>' . "\n";

      // akcje adminowe
      if (($isadmin) && ($action === 'usunzdjecie')) {
        unlink("data/{$artid}/" . urldecode($zdjid));
        if (empty(ListaPlikow($artid, 0))) rmdir('data/' . $artid); // usuń katalog jeśli już nic w nim nie ma
        $action = 'zdjecia';
      }

      if (($isadmin) && ($action === 'nowywpis')) { // nowy wpis
        $art_title = '';
        $art_body = '';
        if (! empty($artid)) { // edycja istniejącego wpisu
          if ($artid < 0) {
            $art_body = file_get_contents('welcome.txt');
          } else {
            $plik = LadujPlikLinii("data/{$artid}.txt");
            $art_title = $plik[0];
            $art_body = $plik[1];
          }
        }
        echo '<form action="' . PaginationLink($p, '', -1) . '" method="post" class="nowywpis">' . "\n";
        echo "<div class=\"nowywpis\">\n";
        if (! empty($artid)) {
          echo '<input type="hidden" id="artid" name="artid" value="' . $artid . '">' . "\n";
        }
        echo '<input type="hidden" id="action" name="action" value="dodajwpis">' . "\n";
        if (empty($artid) || ($artid >= 0)) {
          echo '<p>' . htmlentities($LANG_TITLE) . "</p>\n";
          echo '<input type="text" id="arttit" name="arttit" value="' . htmlentities($art_title) . '">' . "\n";
          echo '<p>' . htmlentities($LANG_MESSAGE) . "</p>\n";
        }
        echo '<textarea name="artbody" id="artbody" rows="20">' . "\n";
        echo htmlentities($art_body);
        echo "</textarea>\n";
        echo "</div>\n";
        echo '<p style="text-align: center;"><a href="' . PaginationLink($p, '', -1) . '">' . htmlentities($LANG_CANCEL) . '</a> <input type="submit" value="' . htmlentities($LANG_SAVE) . '" style="width: auto;"></p>' . "\n";
        echo "</form>\n";
        goto BOTTOM;
      } else if (($isadmin) && ($action === 'zdjecia') && (! empty($artid))) { // zarządzanie zdjęciami
        echo '<p>' . htmlentities($LANG_FILESMGMT) . "</p>\n";
        echo '<form action="./?artid=' . $artid . '&amp;action=uploadzdjecie" class="dropzone" id="formularzdropzone"></form>' . "\n";
        echo '<p class="admintool" style="text-align: center;"><a href="./?artid=' . $artid . '&amp;action=zdjecia&amp;p=' . $p . '">' . htmlentities($LANG_REFRESH) . '</a> <a href="' . PaginationLink($p, '', -1) . '">' . htmlentities($LANG_GOBACK) . '</a></p>' . "\n";
        echo '<script src="./dropzone593/dropzone.min.js"></script>' . "\n";
        echo '<script>Dropzone.options.formularzdropzone = {';
        if (!empty($RESIZEJPG_MAXWIDTH)) echo 'resizeWidth: ' . intval($RESIZEJPG_MAXWIDTH) . ', ';
        if (!empty($RESIZEJPG_MAXHEIGHT)) echo 'resizeHeight: ' . intval($RESIZEJPG_MAXHEIGHT) . ', ';
        echo 'dictDefaultMessage: "' . $LANG_DROPFILESHERE . '"};</script>' . "\n";
        $lista_plikow = ListaPlikow($artid, 0);
        foreach ($lista_plikow as $zd => $flaga_zdj) {
          $icon = 'svg/file.svg';
          if ($flaga_zdj) $icon = "data/{$artid}/" . rawurlencode($zd);
          echo "<div class=\"managezd\"><div class=\"thumbcontainer\" style=\"background-image: url('{$icon}');\"></div><p>" . htmlentities($zd) . '</p><p>' . round(filesize("data/{$artid}/{$zd}") / 1024) . " KiB <a href=\"./?artid={$artid}&amp;action=usunzdjecie&amp;zdjid=" . rawurlencode($zd) . "\"><img src=\"svg/trash.svg\" style=\"height: 1em; width: auto;\"></a></p></div>\n";
        }
        goto BOTTOM;
      } else if (($isadmin) && ($action === 'uploadzdjecie')) { // dropzone upload zdjęcia
        //$fh = fopen('log.txt', 'a');
        //fwrite($fh, "--- UPLOAD ---\n");
        if (!is_dir("data/{$artid}")) mkdir("data/{$artid}");
        foreach ($_FILES as $fname) {
        //  fwrite($fh, $fname['name'] . "\n");
          move_uploaded_file($fname['tmp_name'], "data/{$artid}/{$fname['name']}");
        }
        //fclose($fh);
      } else if (($isadmin) && ($p == 0)) { // nic szczególnego
        echo "<p class=\"admintool\"><a href=\"./?action=nowywpis\">" . htmlentities($LANG_NEWENTRY) . "</a></p>\n";
      }

      echo '<div class="searchbar">';
      echo '<form action="./" method="GET">';
      echo '<input type="text" name="search" placeholder="' . htmlentities($LANG_SEARCH) . '"';
      if (!empty($filter)) echo ' value="' . htmlentities($filter) . '"';
      echo '>';
      echo "</form></div>\n";

      // wylistuj dostępne artykuły
      $arty = LadujArtykuly($filter);
      $liczbastron = intval((count($arty) / $ENTRIES_PER_PAGE) + 0.9);
      if ($liczbastron < 1) $liczbastron = 1;
      if ($p > 0) array_splice($arty, 0, ($liczbastron - $p) * $ENTRIES_PER_PAGE); // usuń nieinteresujące wpisy PRZED
      array_splice($arty, $ENTRIES_PER_PAGE); // zostaw odpowiednią ilość wpisów do wyświetlenia
      $licznik = 0;

      if (empty($arty)) {
        if (empty($filter)) {
          echo '<p class="autherr">' . htmlentities($LANG_NOARTS) . '</p>' . "\n";
        } else {
          echo '<p class="autherr">' . htmlentities($LANG_NOMATCH) . ' "' . htmlentities($filter) . '"</p>' . "\n";
        }
      }

      foreach ($arty as $art) {
        $licznik++;
        $artcontent = LadujPlikLinii("data/{$art}.txt");
        echo "<div class=\"blogentry\">\n";
        if ($isadmin) {
          echo "<p class=\"admintool\"><a href=\"./?action=nowywpis&amp;artid={$art}&amp;p={$p}\"><img src=\"svg/edit.svg\"></a></p>\n";
        }
        echo "<h2>{$artcontent[0]}</h2>\n";
        echo '<h3>' . strftime($TIMESTAMPFORMAT, $art) . "</h3>\n";
        markdownoutput($artcontent[1]);
        // mamy jakieś załączniki? (nie zdjęcia)
        $lista_plikow = ListaPlikow($art, 2);
        if (!empty($lista_plikow)) {
          echo '<p>';
          foreach ($lista_plikow as $plik => $plik_flaga) {
            echo "<img src=\"svg/file.svg\" style=\"height: 1em; width: auto;\"> <a href=\"data/{$art}/" . rawurlencode($plik) . "\">" . htmlentities($plik) . "</a> (" . round(filesize("data/{$art}/{$plik}") / 1024) . " KiB)<br>\n";
          }
          echo "</p>\n";
        }
        // SLAJDY START
        $lista_zdjec = ListaPlikow($art, 1);
        if (! empty($lista_zdjec)) {  // zdjęcia?
          echo '<div class="simple-slider simple-slider-' . $licznik . '">' . "\n";
          if (count($lista_zdjec) > 1) echo '  <div class="slider-wrapper">' . "\n";
          foreach ($lista_zdjec as $f => $flaga_zdj) {
            echo '    <div class="slider-slide" style="background-image: url(\'data/' . $art . '/' . rawurlencode($f) . '\'); background-size: contain;"></div>' . "\n";
          }
          if (count($lista_zdjec) > 1) {
            echo "  </div>\n";
            echo '  <div class="slider-btn slider-btn-prev"></div>' . "\n";
            echo '  <div class="slider-btn slider-btn-next"></div>' . "\n";
          }
          echo "</div>\n";
          if (count($lista_zdjec) > 1) echo "<script>var slide = new SimpleSlider('.simple-slider-{$licznik}', {autoplay: false, speed: 700});</script>\n";
        }
        // SLAJDY STOP

        if ($isadmin) {
          echo "<p class=\"admintool\"><a href=\"./?action=zdjecia&amp;artid={$art}&amp;p={$p}\"><img src=\"svg/attachadd.svg\"></a></p>\n";
        }
        echo "</div>\n";
      }
      echo '<p class="paginacja">';
      $listastron = ListaStronDoPaginacji($p, $liczbastron);
      foreach ($listastron as $s) {
        if ($s > 0) {
          $class = '';
          if (($s == $p) || (($p == 0) && ($s == $liczbastron))) $class = 'class="curpage" ';
          echo "<a {$class}href=\"" . PaginationLink($s, $filter, $liczbastron) . "\">{$s}</a> ";
        } else {
          echo "&hellip; ";
        }
      }
      echo "</p>\n";

      BOTTOM:
    ?>
    </div>
  </body>
</html>
